<?php

namespace App\Http\Controllers\owner;

use App\Http\Controllers\Controller ;

use App\Models\SiteSetting;
use App\Models\admin\Category;
use Illuminate\Support\Facades\Auth;
use View;

class OwnerBaseController extends Controller
{
   
    
    public function __construct(){
        
          parent::__construct();
       
            $this->middleware('auth_owner');
//         $this->middleware(function ($request, $next) {
//
//            $this->user = Auth::guard('owner')->user();
//
//            return $next($request);
//        });
      //  dd(auth()->user());
    // dd($this->user);
//        if(Auth::guard('owner')->user()->guard !== owner){
//            dd('not_owner');
//        }else{
//            dd('owner');
//        }
       // dd($this->get_site_setting());
        View::share('site_setting',$this->get_site_setting()); 

        
    }
    
    public function get_site_setting(){
        $site_setting = SiteSetting::first();
        return $site_setting;
    }

    
        
    public function get_category_tree($parent_id = 0, $cat_level = -1, $filter = array()) {
        $categories = array();
        //$res = Category::all()->where('parent_id', '=', $parent_id)->where('active', '=', '1');
        $conditions = array();
        $conditions[] = [ 'status', '=', '1' ];
        $conditions[] = [ 'parent_id', '=', $parent_id ];
        if(count($filter) > 0) {
            foreach ($filter as $key => $value) {
                $conditions[] = [ $key, '=', $value ];
            }
        }
        //dd($conditions);
        $res = Category::with('parent', 'children')->where($conditions)->orderBy('display_order', 'asc')->get();
        $loop = 0;
        $cat_level++;

        foreach ($res as $row) {
            $category = array();
            $category['id'] = $row->id;
            $category['parent_id'] = $row->parent_id;
            $category['cat_name'] = $row->cat_name;
            $category['slug'] = $row->slug;
            $category['cat_level'] = $cat_level;
            $category['parent_names'] = $row->getParentsNames();
            $category['sub_categories'] = $this->get_category_tree($category['id'], $cat_level, $filter);
            //$categories[$row['id']] = $category;
            $categories[$loop] = $category;
            $loop++;
        }
        //dd($categories);
        return $categories;
    } // end function get_category_tree()
    
    
    public function get_category_tree_list($category_tree, $match = -1) {
        $html = ""; 
        foreach( $category_tree as $key => $val ) {
            $cat_level = $val['cat_level'] + 1;
            $t = "";
            for($a = 1; $a <= $cat_level; $a++) {
                $t.= "-----"; 
            }
            $t.= " ";
            
            $slt = ( $match == $val['id'] ) ? 'selected="selected"': '' ;

            $html.= '<option ' . $slt . ' value="' . $val['id'] . '">' . $t . ucfirst($val['cat_name']) . '</option>';
            $temp = $this->get_category_tree_list($val['sub_categories'], $match);
            $html.= $temp;
        }
        return $html;
    } // end function get_category_tree_list()
    
       public function get_category_tree_list_checkbox($category_tree, $match = array(), $disable = false) {
        $html = ""; 
        foreach( $category_tree as $key => $val ) {
            $cat_level = $val['cat_level'] + 1;
            $t = -20;
            for($a = 1; $a <= $cat_level; $a++) {
                $t+= 25; 
            }

            $chk = ( in_array($val['id'], $match) ) ? 'checked="checked"': '' ;
            $dis = ( $disable == true ) ? 'disabled="disabled"' : '';

            $html.= '<tr class="cat_row parent_cat_row_'.$val['parent_id'].' cat_row_'.$val['id'].'"><td style="padding-left: ' . $t . 'px;">
            <label style="cursor: pointer;" for="label_chk_'.$val['id'].'"><input '.$dis.' '. $chk .' type="checkbox" name="categories[]" id="label_chk_'.$val['id'].'" value="' . $val['id'] . '" class="minimal"/>&nbsp;' . ucfirst($val['cat_name']) . '</label></td></tr>';

            $temp = $this->get_category_tree_list_checkbox($val['sub_categories'], $match, $disable);
            $html.= $temp;
        }
        return $html;
    } // end function get_category_tree_list()
    
       
      public function get_category_tree_list_dropdown($category_tree, $match = -1) {
        $html = ""; 
        foreach( $category_tree as $key => $val ) {
            $cat_level = $val['cat_level'] + 1;
            $t = "";
            for($a = 1; $a <= $cat_level; $a++) {
                $t.= "-----"; 
            }
            $t.= " ";
            
            $slt = ( $match == $val['id'] ) ? 'selected="selected"': '' ;

            $html.= '<option ' . $slt . ' value="' . $val['id'] . '">' . $t . ucfirst($val['cat_name']) . '</option>';
            $temp = $this->get_category_tree_list_dropdown($val['sub_categories'], $match);
            $html.= $temp;
        }
        return $html;
    } // end function get_category_tree_list_dropdown()
 
    
    
}
